/*******************************************************
Filename		:  citation_table.sql
Release 		:  
SIR			:  
Description		:  Creates MetaData Bibliographic Citation table and related constraints and populates data.
Author			:  Suganthi Sivakumar
Date			:  6/13/2006.
Comments		:  
**********************************************************/

/**********************************************************
Create sequences for MetaData Bibliographic Citation table
***********************************************************/
set echo on 
spool citation_table.log
--drop sequence  seq_md_citation;

create sequence seq_md_citation
start with 1 increment by 1 nomaxvalue nocycle cache 10;

/*******************************************************
Create MetaData Bibliographic Citation table
**********************************************************/
--drop table md_citation;

create table md_citation
( pk_isn number(12,0),
  organization_id VARCHAR2(256 char) not null,
  citation_is_number number(12,0) not null,
  organization_is_number number(12,0),
  citation_id VARCHAR2(256 char),
  title VARCHAR2(1999 char) not null,
  author VARCHAR2(256 char) not null,
  pblshr_org_name VARCHAR2(256 char) not null,
  publishing_year VARCHAR2(256 char) not null,
  vol_and_page VARCHAR2(256 char) not null,
  reference_id VARCHAR2(256 char),
  comments VARCHAR2(256 char));

alter table md_citation
add constraint pk_citation primary key (pk_isn)
using index
tablespace  STORETINDX
storage(initial 300k next 300k)
nologging;

create index icit_org_id on md_citation(organization_id)
tablespace STORETINDX
storage(initial 512k next 512k)
nologging;

commit;

/*  moved to bottom
alter table md_citation
add( fk_org number(12,0));

update md_citation ci
set fk_org =(select pk_isn from di_org o
              where o.organization_is_number=ci.organization_is_number)
where ci.organization_is_number is not null;
commit;

create index icitfk on md_citation(fk_org)
tablespace STORETINDX
storage (initial 512k next 512k)
nologging;

commit;


alter table md_citation
add constraint fk_md_cit foreign key (fk_org) references di_org(pk_isn);

commit;
*/

/********************************************************
Populate MetaData Bibliographic Citation table with data.
*********************************************************/

set serveroutput on
declare 
cursor c_citation is 
select TSRCITN_ORG_ID,TSRCITN_IS_NUMBER,TSMORGAN_IS_NUMBER,IDENTIFICATION_CD,TITLE_NAME,AUTHOR_NAME,JRNL_OR_PBLSHR_NM,PUBLICATION_YEAR,VOL_AND_PG_NUM,ORG_REF_ID_NUM,COMMENT_TEXT
from storet1.tsrcitn; 

begin
  for c_var in c_citation loop
    insert into md_citation
    (pk_isn,organization_id,citation_is_number,organization_is_number,citation_id,title,author,pblshr_org_name,publishing_year,vol_and_page,reference_id,comments)
    values
    (seq_md_citation.nextval,c_var.tsrcitn_org_id,c_var.tsrcitn_is_number,c_var.tsmorgan_is_number,c_var.identification_cd,c_var.title_name,c_var.author_name,c_var.jrnl_or_pblshr_nm,c_var.publication_year,c_var.vol_and_pg_num,c_var.org_ref_id_num,c_var.comment_text);
  end loop;
end;
/
commit;
alter table md_citation
add( fk_org number(12,0));

update md_citation ci
set fk_org =(select pk_isn from di_org o
              where o.organization_is_number=ci.organization_is_number)
where ci.organization_is_number is not null;
commit;

create index icitfk on md_citation(fk_org)
tablespace STORETINDX
storage (initial 512k next 512k)
nologging;

commit;
-- moved the constraint down after creating the fk_org.  test defect fix
alter table md_citation
add constraint fk_md_cit foreign key (fk_org) references di_org(pk_isn);

commit;

alter table md_citation add SOURCE_SYSTEM VARCHAR2(256 CHAR);
alter table md_citation add SOURCE_UID NUMBER(20);
commit;

alter table md_citation modify citation_is_number number(12,0) null;


spool off;
